{{-- resources/views/components/notification.blade.php

@if (session('success') || session('error'))

<style>
    .notification-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.4);
        z-index: 9998;
        animation: fadeIn 0.3s ease-out;
        backdrop-filter: blur(3px);
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }

    .notification-modal {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        z-index: 9999;
        animation: slideUp 0.3s ease-out;
    }

    @keyframes slideUp {
        from {
            opacity: 0;
            transform: translate(-50%, -40%);
        }
        to {
            opacity: 1;
            transform: translate(-50%, -50%);
        }
    }

    .notification-content {
        background: white;
        border-radius: 16px;
        padding: 32px;
        max-width: 420px;
        width: 90vw;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        text-align: center;
    }

    .notification-icon {
        width: 64px;
        height: 64px;
        margin: 0 auto 20px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 32px;
        animation: scaleIn 0.4s ease-out;
    }

    @keyframes scaleIn {
        from {
            transform: scale(0.8);
            opacity: 0;
        }
        to {
            transform: scale(1);
            opacity: 1;
        }
    }

    .notification-icon.success {
        background: #d4edda;
        color: #28a745;
    }

    .notification-icon.error {
        background: #f8d7da;
        color: #dc3545;
    }

    .notification-title {
        font-size: 20px;
        font-weight: 600;
        color: #212529;
        margin-bottom: 10px;
    }

    .notification-message {
        font-size: 14px;
        color: #6c757d;
        margin-bottom: 28px;
        line-height: 1.6;
    }

    .notification-button {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border: none;
        padding: 12px 32px;
        border-radius: 10px;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.2s;
    }

    .notification-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 16px rgba(102, 126, 234, 0.3);
    }

    .notification-button:active {
        transform: translateY(0);
    }

    .notification.hide .notification-overlay,
    .notification.hide .notification-modal {
        animation: fadeOut 0.3s ease-out forwards;
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
            transform: translate(-50%, -50%);
        }
        to {
            opacity: 0;
            transform: translate(-50%, -60%);
        }
    }

    @media (max-width: 640px) {
        .notification-content {
            padding: 24px;
            max-width: 90vw;
        }

        .notification-title {
            font-size: 18px;
        }

        .notification-message {
            font-size: 13px;
            margin-bottom: 24px;
        }

        .notification-button {
            padding: 10px 24px;
            font-size: 13px;
        }
    }
</style>

<div class="notification" id="notificationModal">
    <div class="notification-overlay" onclick="closeNotification()"></div>

    <div class="notification-modal">
        <div class="notification-content">
            @if (session('success'))
                <div class="notification-icon success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <h3 class="notification-title">Berhasil!</h3>
                <p class="notification-message">
                    {{ session('success') }}
                </p>
            @endif

            @if (session('error'))
                <div class="notification-icon error">
                    <i class="fas fa-exclamation-circle"></i>
                </div>
                <h3 class="notification-title">Terjadi Kesalahan</h3>
                <p class="notification-message">
                    {{ session('error') }}
                </p>
            @endif

            <button class="notification-button" onclick="closeNotification()">
                Tutup
            </button>
        </div>
    </div>
</div>

<script>
    function closeNotification() {
        const modal = document.getElementById('notificationModal');
        modal.classList.add('hide');
        setTimeout(() => {
            modal.remove();
        }, 300);
    }

    // Auto close setelah 5 detik
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('notificationModal');
        if (modal) {
            setTimeout(() => {
                closeNotification();
            }, 5000);
        }
    });
</script>

@endif --}}

{{-- resources/views/components/notification.blade.php --}}

@if (session('success') || session('error') || session('warning') || session('info'))

<style>
    .notification-container {
        position: fixed;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 9999;
        max-width: 500px;
        width: 90vw;
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .notification-item {
        display: flex;
        align-items: flex-start;
        gap: 12px;
        padding: 16px 20px;
        border-radius: 12px;
        border-left: 4px solid;
        animation: slideDownIn 0.3s ease-out;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
        background: white;
        position: relative;
    }

    @keyframes slideDownIn {
        from {
            opacity: 0;
            transform: translateY(-30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .notification-item.success {
        border-left-color: #28a745;
        background: linear-gradient(135deg, #f0fdf4 0%, #f1fdf5 100%);
    }

    .notification-item.error {
        border-left-color: #dc3545;
        background: linear-gradient(135deg, #fef2f2 0%, #fef5f5 100%);
    }

    .notification-item.warning {
        border-left-color: #ffc107;
        background: linear-gradient(135deg, #fffbf0 0%, #fffcf5 100%);
    }

    .notification-item.info {
        border-left-color: #0d6efd;
        background: linear-gradient(135deg, #f0f7ff 0%, #f1f9ff 100%);
    }

    .notification-icon {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
        flex-shrink: 0;
        font-weight: 600;
    }

    .notification-item.success .notification-icon {
        background: #d4edda;
        color: #28a745;
    }

    .notification-item.error .notification-icon {
        background: #f8d7da;
        color: #dc3545;
    }

    .notification-item.warning .notification-icon {
        background: #fff3cd;
        color: #ffc107;
    }

    .notification-item.info .notification-icon {
        background: #cfe2ff;
        color: #0d6efd;
    }

    .notification-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        gap: 4px;
    }

    .notification-title {
        font-weight: 600;
        font-size: 14px;
        color: #212529;
    }

    .notification-item.success .notification-title {
        color: #155724;
    }

    .notification-item.error .notification-title {
        color: #721c24;
    }

    .notification-item.warning .notification-title {
        color: #856404;
    }

    .notification-item.info .notification-title {
        color: #084298;
    }

    .notification-message {
        font-size: 13px;
        color: #6c757d;
        line-height: 1.4;
    }

    .notification-item.success .notification-message {
        color: #155724;
    }

    .notification-item.error .notification-message {
        color: #721c24;
    }

    .notification-item.warning .notification-message {
        color: #856404;
    }

    .notification-item.info .notification-message {
        color: #084298;
    }

    .notification-close {
        background: none;
        border: none;
        color: #6c757d;
        cursor: pointer;
        font-size: 18px;
        padding: 0;
        flex-shrink: 0;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        width: 24px;
        height: 24px;
    }

    .notification-close:hover {
        color: #212529;
        transform: scale(1.1);
    }

    .notification-item.hide {
        animation: slideUpOut 0.3s ease-out forwards;
    }

    @keyframes slideUpOut {
        from {
            opacity: 1;
            transform: translateY(0);
        }
        to {
            opacity: 0;
            transform: translateY(-30px);
        }
    }

    @media (max-width: 640px) {
        .notification-container {
            top: 10px;
            width: 95vw;
            max-width: none;
        }

        .notification-item {
            padding: 14px 16px;
            gap: 10px;
        }

        .notification-title {
            font-size: 13px;
        }

        .notification-message {
            font-size: 12px;
        }
    }
</style>

<div class="notification-container">
    @if (session('success'))
        <div class="notification-item success" id="notification-success">
            <div class="notification-icon">
                <i class="fas fa-check"></i>
            </div>
            <div class="notification-content">
                <div class="notification-title">Sukses!</div>
                <div class="notification-message">{{ session('success') }}</div>
            </div>
            <button class="notification-close" onclick="removeNotification(this)">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="notification-item error" id="notification-error">
            <div class="notification-icon">
                <i class="fas fa-times"></i>
            </div>
            <div class="notification-content">
                <div class="notification-title">Terjadi Kesalahan</div>
                <div class="notification-message">{{ session('error') }}</div>
            </div>
            <button class="notification-close" onclick="removeNotification(this)">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    @if (session('warning'))
        <div class="notification-item warning" id="notification-warning">
            <div class="notification-icon">
                <i class="fas fa-exclamation"></i>
            </div>
            <div class="notification-content">
                <div class="notification-title">Peringatan</div>
                <div class="notification-message">{{ session('warning') }}</div>
            </div>
            <button class="notification-close" onclick="removeNotification(this)">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    @if (session('info'))
        <div class="notification-item info" id="notification-info">
            <div class="notification-icon">
                <i class="fas fa-info"></i>
            </div>
            <div class="notification-content">
                <div class="notification-title">Informasi</div>
                <div class="notification-message">{{ session('info') }}</div>
            </div>
            <button class="notification-close" onclick="removeNotification(this)">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif
</div>

<script>
    function removeNotification(button) {
        const notification = button.closest('.notification-item');
        notification.classList.add('hide');
        setTimeout(() => {
            notification.remove();
        }, 300);
    }

    // Auto close setelah 4 detik
    document.addEventListener('DOMContentLoaded', function() {
        const notifications = document.querySelectorAll('.notification-item');
        notifications.forEach(notification => {
            setTimeout(() => {
                if (notification && notification.parentElement) {
                    notification.classList.add('hide');
                    setTimeout(() => {
                        notification.remove();
                    }, 300);
                }
            }, 4000);
        });
    });
</script>

@endif
